#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../generator.h"

static Obj3d *pVagues;
static float Matrix[16];

static float Cos256f[256];
static float Sin256f[256];

void LInit_VaguesTransp()
{
	int Cpt1;

	for(Cpt1=0;Cpt1<256;Cpt1++)
	{
		Cos256f[Cpt1] = 128.f * (float)cos(Cpt1*PI2/256.f);
		Sin256f[Cpt1] = 128.f * (float)sin(Cpt1*PI2/256.f);
	}

	pVagues = GenerateFloor(20, 10, 800, 600, 256, 256);
	PrepareTextureFromArray(g_PicBof, 256, 256, &g_TextureBof);
}

void QInit_VaguesTransp()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_ALWAYS);

	grConstantColorValue(192<<24);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	DownloadTexture(&g_TextureBof);
	SelectTexture(g_TextureBof);

	grCullMode(GR_CULL_DISABLE);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grFogMode(GR_FOG_DISABLE);
	grDepthMask(FXFALSE);

}

void Effect_VaguesTransp()
{
	static int Cpt1, Cpt2;
	static int Cpt3;
	int Img1;
	static FbVertex *pVtx;
	static float Cpt1Sin;
	static int sow, tow;

	Cpt3=0;
	Img1 = g_demostate.TickInEffect/10;

	pVtx = pVagues->pVertexIn;

	tow = Img1/4;
	for(Cpt1=0;Cpt1<11*48;Cpt1+=48)
	{
		sow = Img1/4;
		Cpt1Sin = Sin256f[(Img1+Cpt1)&255];
		for(Cpt2=0;Cpt2<21*24;Cpt2+=24)
		{
			/*pVtx->tmuvtx[0].sow ++;
			pVtx->tmuvtx[0].tow ++;*/
			pVtx->tmuvtx[0].sow = sow;
			sow+=8;
			pVtx->tmuvtx[0].tow = tow;
			(pVtx++)->z = Cpt1Sin + Cos256f[(Img1+Cpt2)&255];
		}
		tow+=16;
	}

	BeIdentityMatrix(Matrix);
	TranslateMatrix(Matrix,0,0,600);
	grConstantColorValue((92<<24)+(128<<16));
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);

	DrawWithMatrix(pVagues, Matrix, 0, 0, 0);

	grConstantColorValue((92<<24)+(128<<8));
	grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA, 
		GR_BLEND_ZERO, GR_BLEND_ZERO);

	TranslateMatrix(Matrix,0,0,-100);
	DrawWithMatrix(pVagues, Matrix, 0, 0, 0);
	
	grConstantColorValue((92<<24)+(128));
	grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA, 
		GR_BLEND_ZERO, GR_BLEND_ZERO);

	TranslateMatrix(Matrix,0,0,-100);
	DrawWithMatrix(pVagues, Matrix, 0, 0, 0);
}

void ByeBye_VaguesTransp()
{
	FreeTexture(&g_TextureBof);
	grDepthMask(FXTRUE);
}